PROGRAM Foerderband
  VAR
    Start AT %IX0.0 : BOOL;
    SensorLinks AT %IX0.1 : BOOL;
    SensorRechts AT %IX0.2 : BOOL;
    MotorOn AT %QX0.0 : BOOL;
    MotorDir AT %QX0.1 : BOOL;
    Barcode AT %QX0.2 : BOOL;
    LedOK AT %QX0.4 : BOOL;
    BlinkLed AT %QX0.7 : BOOL;
  END_VAR
  VAR
    TimerBlink : TON;
    TimeerMotor : TON;
    TimerBlinkReady : BOOL := FALSE;
    TimerMotorReady : BOOL := FALSE;
    State : INT := 0;
  END_VAR

  (* Programm Transportband *)
  (* LED blinken lassen *)
    TimerBlink(IN:= NOT TimerBlink.Q,PT:=T#500ms,Q=>TimerBlinkReady);
    
    IF TimerBlinkReady THEN 
      BlinkLed:=NOT BlinkLed;
    END_IF;


  (* State Machine fuer das Transportband *)
  (* Wenn der Start Taster und der Kontakt SensorLinks *)
  (* betaetigt werden startet das Transportband nach rechts *)
  (* wenn die rechte Position erreicht ist stoppt das Band *)
  (* und wartet 5 Sekunden , dabei wird die Leitung Barcode geschaltet*)
  (* Danach faehrt es wieder nach links bis SensorLinks betätigt wird *) 
    CASE State OF
         (* Startbedingung  *) 
         0: IF (Start AND SensorLinks) THEN
          State:=10;
        END_IF;
      (* Rechte Position erreicht *)
      10: IF SensorRechts THEN
          State:=20;
         END_IF;
      (* 5 Sekunden warten dann nach links *)
      20:TimeerMotor(IN:= NOT TimeerMotor.Q,PT:=T#5S,Q=>TimerMotorReady);
          IF TimerMotorReady THEN
            State:=30;
          END_IF;
      (* Motor wieder nach links *)
      30: IF SensorLinks THEN
          State:=0;
          END_IF;
    END_CASE;  

  (* Schalten der Motor und Barcode Leitungen *)
      
    CASE State OF
      0:MotorOn:=FALSE; MotorDir:=FALSE;LedOK:=0;
      10:MotorOn:=TRUE; MotorDir:=TRUE;
      20:MotorOn:=FALSE; MotorDir:=FALSE;Barcode:=1;
      30:MotorOn:=TRUE; MotorDir:=FALSE;Barcode:=0;LedOK:=1;
    END_CASE; 
    
END_PROGRAM


CONFIGURATION Config0

  RESOURCE Res0 ON PLC
    TASK task0(INTERVAL := T#20ms,PRIORITY := 0);
    PROGRAM instance0 WITH task0 : Foerderband;
  END_RESOURCE
END_CONFIGURATION
